/* c4text.c - front end user interface for c4.c
 * (C) Paul A. Marshall 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "c4.h"
#include "c4mac.h"

void display_board(void);
int usermove(char player);

int main(int argc, char *argv[])
{
	char sorf;
	char uplayer, cplayer;
	
	init_game();
	printf("\n\nWelcome to C4");
	printf("\n\nEnter difficulty level (7 - 12) :");
	scanf("%d", &pdepth);
	while ((pdepth < 7) || (pdepth > 12)) {
		printf("\nInvalid entry, please try again :");
		scanf("%d", &pdepth);
	}
	printf("\n\nWould you like to go first or second? (f/s) :");
	scanf("\n%c", &sorf);
	sorf = tolower(sorf);
	while ((sorf != 's') && (sorf != 'f')) {
		printf("\nInvalid entry, please try again :");
		scanf("%c", &sorf);
		sorf = tolower(sorf);
	}
	if (sorf == 'f') {
		uplayer = PLAYER1;
		cplayer = PLAYER2;
	}
	else {
		uplayer = PLAYER2;
		cplayer = PLAYER1;
	}
	while (movenum < TOTALCELLS) {
		display_board();
		if (((sorf == 'f') && (!(movenum & 1))) ||
			((sorf == 's') && (movenum & 1))) {
			if (usermove(uplayer)) {
				display_board();
				printf("\nBah! You win!\n");
				exit(0);
			}
		}
		else {
			printf("\nI am thinking....\n");
			if (computer_move(cplayer)) {
				display_board();
				printf("\nHa! Ha! I win!\n");
				exit(0);
			}
		}
	}
	printf("\nA draw!\n");
	exit(0);
}

/* display the playing board */
void display_board(void)
{
	int i, j;
	char dispch;

	for (j = ROWS - 1; j >= 0; j--) {
		printf("\n\n");
		for (i = 0; i < COLS; i++) {
			if (board[i][j] == 0)
				dispch = '.';
			if (board[i][j] == PLAYER1)
				dispch = 'X';
			if (board[i][j] == PLAYER2)
				dispch = 'O';
			printf("  %c  ", dispch);
		}
	}
	printf("\n\n\n  0    1    2    3    4    5    6\n");
}

int usermove(char player)
{
	int move;
	
	printf("\nEnter column number to play (0-%d) :", COLS - 1);
	scanf("%d", &move);
	while ((move > (COLS - 1)) || (move < 0) || (!valid_move(move))) {
		printf("\nInvalid entry, please try again :");
		scanf("%d", &move);
	}
	if (user_move(player, move))
		return 1;
	else
		return 0;
}
