/* c4gtk.c - front end user interface for c4.c
 * (C) Paul A. Marshall 2002
 * My apologies to anyone who *does* know how to write a gtk program.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */ 

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "c4.h"
#include "pixmaps.h"
#include "info.h"

/* generate_signal is a way to separate parts of the program so as they are not 
 * run under the same signal handler. Apart from logical separation, it allows
 * widget changes to be rendered before moving on and it allows signal
 * disabling to work. I am sure there are *far* more sensible ways of achieving
 * this.... 
 */
#define generate_signal(A) gtk_timeout_add(100, (GtkFunction) A, NULL)
#define tentochar(A) ((((A) - ((A) % 10)) / 10) + '0')
#define unittochar(A) (((A) % 10) + '0')
#define twodigstr(A) ((*(A) - '0') * 10 + (*(A + 1) - '0'))

gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data);
void destroy(GtkWidget *widget, gpointer data);
void enter_table(int y, int x, GtkWidget *content);
GtkWidget *makebutton(char *label, GtkSignalFunc func);
gint userplay(gpointer data);
gint compplay(gpointer data);
gint endgame(gpointer data);
void display_board(void);
void enable_buttons(void);
void disable_buttons(void);

GtkWidget *window;
GtkWidget *popup;
GtkWidget *table, *prompt;
GtkWidget *tablewid[COLS + 2][ROWS + 3];
GtkWidget *start_mi, *restart_mi;
GtkWidget *button[COLS];
guint button_hid[COLS];
gint bid[COLS];
int btns_enabled;

GdkPixmap *emptysq_pm, *redsq_pm, *yelsq_pm, *offredsq_pm, *offyelsq_pm;
GdkBitmap *emptysq_mask, *redsq_mask, *yelsq_mask, *offredsq_mask;
GdkBitmap *offyelsq_mask;
GdkPixmap *rvedge_pm, *lvedge_pm, *bedge_pm;
GdkBitmap *rvedge_mask, *lvedge_mask, *bedge_mask;
GdkPixmap *trcorner_pm, *tlcorner_pm, *blcorner_pm, *brcorner_pm;
GdkBitmap *trcorner_mask, *tlcorner_mask, *blcorner_mask, *brcorner_mask;

int main(int argc, char *argv[])
{
	GtkWidget *setupmenus(void);
	void setuppixmaps(void);
	void setupbuttons(void);
	void buildboard(void);
	
	GtkWidget *vbox;

	pdepth = 4;
	btns_enabled = 0;
	gtk_init(&argc, &argv);
	
	/* set up window with basic framework ready to accept contents */
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window), "C4");
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(window), vbox);
	table = gtk_table_new(COLS + 2, ROWS + 3, FALSE);
	prompt = gtk_label_new("*** Welcome to C4 ***");
	gtk_box_pack_start(GTK_BOX(vbox), setupmenus(), FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), prompt, FALSE, FALSE, 0);
	
	/* set up misc event handler functions */
	gtk_signal_connect(GTK_OBJECT(window), "delete_event",
			GTK_SIGNAL_FUNC(delete_event), NULL);
	gtk_signal_connect(GTK_OBJECT(window), "destroy",
			GTK_SIGNAL_FUNC(destroy), NULL);

	/* set up the rest.. */
	setuppixmaps();
	setupbuttons();
	buildboard();
	gtk_widget_show(prompt);
	gtk_widget_show(table);
	gtk_widget_show(vbox);
	gtk_widget_show(window);

	gtk_main();

	return 0;
}

gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	/* for now we'll just let it exit
	 * later we might put in an "are you sure?" dialogue
	 */
	return FALSE;
}

void destroy(GtkWidget *widget, gpointer data)
{
	gtk_main_quit();
}

/* set up in readiness for the user's move */
gint userplay(gpointer data)
{
	char promptext[] = "Move : 00 --- Your turn.";

	promptext[7] = tentochar(movenum + 1);
	promptext[8] = unittochar(movenum + 1);
	gtk_label_set_text(GTK_LABEL(prompt), promptext);
	gtk_widget_show(prompt);
	enable_buttons();
	return FALSE;
}

/* user move - initiated by column button press */
gint usermove(GtkWidget *widget, gpointer data)
{
	int column;
	
	column = *((int *) data);
	if (! valid_move(column))
		return TRUE;
	disable_buttons();
	if (user_move((movenum & 1)?PLAYER2 : PLAYER1, column)) {
		gtk_label_set_text(GTK_LABEL(prompt), "Bah! You win!");
		generate_signal(endgame);
		return TRUE;
	}
	if (movenum == TOTALCELLS) {
		gtk_label_set_text(GTK_LABEL(prompt), "It's a draw!");
		generate_signal(endgame);
		return TRUE;
	}
	display_board();
	generate_signal(compplay);
	return TRUE;
}
/* set up in readiness for computer move */
gint compplay(gpointer data)
{
	gint compmove(gpointer data);
	
	char promptext[] = "Move : 00 --- I am thinking....";

	promptext[7] = tentochar(movenum + 1);
	promptext[8] = unittochar(movenum + 1);
	gtk_label_set_text(GTK_LABEL(prompt), promptext);
	gtk_widget_show(prompt);
	generate_signal(compmove);
	return FALSE;
}
	
/* computer move */
gint compmove(gpointer data)
{
	if (computer_move((movenum & 1)?PLAYER2: PLAYER1)) {
		gtk_label_set_text(GTK_LABEL(prompt), "Ha! Ha! I win!");
		generate_signal(endgame);
		return FALSE;
	}
	if (movenum == TOTALCELLS) {
		gtk_label_set_text(GTK_LABEL(prompt), "It's a draw!");
		generate_signal(endgame);
		return FALSE;
	}
	display_board();
	generate_signal(userplay);
	return FALSE;
}

/* end game changes */
gint endgame(gpointer data)
{
	gtk_widget_hide(restart_mi);
	gtk_widget_show(start_mi);
	display_board();
	gtk_widget_show(prompt);
	return FALSE;
}

void enable_buttons(void)
{
	gint usermove(GtkWidget *widget, gpointer data);

	int i;

	for (i = 0; i < COLS; i++) {
		button_hid[i] = gtk_signal_connect(GTK_OBJECT(button[i]),
				"clicked" , GTK_SIGNAL_FUNC(usermove),
				(gpointer) &bid[i]);
	}
	btns_enabled = 1;
}

void disable_buttons(void)
{
	int i;

	for (i = 0; i < COLS; i++)
		gtk_signal_disconnect(GTK_OBJECT(button[i]), button_hid[i]);
	btns_enabled = 0;
}
		
void display_board(void)
{
	int i, j;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	int lmflag = 0;
	
	for (i = 0; i < COLS; i++) {
		for (j = (ROWS - 1); j >= 0; j--) {
			if ((movenum > 0) && (i == lastmove) && (lmflag == 0))
				switch (board[i][j]) {
					case PLAYER1:
						pixmap = offredsq_pm;
						mask = offredsq_mask;
						lmflag = 1;
						break;
					case PLAYER2:
						pixmap = offyelsq_pm;
						mask = offyelsq_mask;
						lmflag = 1;
						break;
					case 0 :
						pixmap = emptysq_pm;
						mask = emptysq_mask;
				}
			else
				switch (board[i][j]) {
					case PLAYER1:
						pixmap = redsq_pm;
						mask = redsq_mask;
						break;
					case PLAYER2:
						pixmap = yelsq_pm;
						mask = yelsq_mask;
						break;
					case 0 :
						pixmap = emptysq_pm;
						mask = emptysq_mask;
				}
			gtk_pixmap_set(GTK_PIXMAP(tablewid[i + 1][ROWS + 1 - j])
					, pixmap, mask);
			gtk_widget_show(tablewid[i + 1][ROWS + 1 - j]);
		}
	}
}

/* dialogues for initiating a new game */
gint start_game(GtkWidget *widget, gpointer data)
{
	gint compfirst(GtkWidget *widget, gpointer data);
	gint userfirst(GtkWidget *widget, gpointer data);
	gint ladyluck(GtkWidget *widget, gpointer data);
	
	GtkWidget *label;
	GtkWidget *first, *second, *luck;

	init_game();
	display_board();
	popup = gtk_dialog_new();
	gtk_window_set_modal(GTK_WINDOW(popup), TRUE);
	gtk_container_set_border_width(GTK_CONTAINER(popup), 10);
	first = makebutton("First", GTK_SIGNAL_FUNC(userfirst));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(popup)->action_area), first,
			TRUE, TRUE, 0);
	second = makebutton("Second", GTK_SIGNAL_FUNC(compfirst));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(popup)->action_area), second,
			TRUE, TRUE, 0);
	luck = makebutton("Lady Luck", GTK_SIGNAL_FUNC(ladyluck));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(popup)->action_area), luck,
			TRUE, TRUE, 0);
	label = gtk_label_new("Would you like to go:\nFirst\nSecond\nor\nLeave it to lady luck?");
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(popup)->vbox), label, TRUE,
				TRUE, 0);
	gtk_widget_show(popup);
	return TRUE;
}

gint compfirst(GtkWidget *widget, gpointer data)
{
	gtk_widget_hide(start_mi);
	gtk_widget_show(restart_mi);
	generate_signal(compplay);
	gtk_widget_destroy(popup);
	return TRUE;
}

gint userfirst(GtkWidget *widget, gpointer data)
{
	gtk_widget_hide(start_mi);
	gtk_widget_show(restart_mi);
	generate_signal(userplay);
	gtk_widget_destroy(popup);
	return TRUE;
}

gint ladyluck(GtkWidget *widget, gpointer data)
{
	gtk_widget_hide(start_mi);
	gtk_widget_show(restart_mi);
	if (rand() & 1)
		generate_signal(compplay);
	else
		generate_signal(userplay);
	gtk_widget_destroy(popup);
	return TRUE;
}
	
gint restart_game(GtkWidget *widget, gpointer data)
{
	gint restart_yes(GtkWidget *widget, gpointer data);
	gint restart_no(GtkWidget *widget, gpointer data);
	
	GtkWidget *byes, *bno, *label;

	popup = gtk_dialog_new();
	gtk_window_set_modal(GTK_WINDOW(popup), TRUE);
	gtk_container_set_border_width(GTK_CONTAINER(popup), 10);
	byes = makebutton("Yes", GTK_SIGNAL_FUNC(restart_yes));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(popup)->action_area), byes,
			TRUE, TRUE, 0);
	bno = makebutton("No", GTK_SIGNAL_FUNC(restart_no));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(popup)->action_area), bno,
			TRUE, TRUE, 0);
	label = gtk_label_new("Do you really want to restart the game?");
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(popup)->vbox), label, TRUE,
				TRUE, 0);
	gtk_widget_show(popup);
	return TRUE;
}

gint restart_yes(GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy(popup);
	if (btns_enabled)
		disable_buttons();
	start_game(widget, NULL);
	return TRUE;
}

gint restart_no(GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy(popup);
	return TRUE;
}

/* select game difficulty level dialogue. This does not prevent level changes
 * during game play - couldn't think of a good reason why not. 
 */
gint difficulty(GtkWidget *widget, gpointer data)
{
	GSList *makeradio(char *label, GSList *group, gpointer data);
	gint diff_ok(GtkWidget *widget, gpointer data);

	GtkWidget *bok;
	GSList *diffgrp;
	
	popup = gtk_dialog_new();
	gtk_window_set_modal(GTK_WINDOW(popup), TRUE);
	gtk_container_set_border_width(GTK_CONTAINER(popup), 10);
	bok = makebutton("OK", GTK_SIGNAL_FUNC(diff_ok));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(popup)->action_area), bok,
			TRUE, TRUE, 0);
	/* fix these rather cute ascii to num things */
	diffgrp = makeradio("Child's Play", NULL, "02");
	diffgrp = makeradio("Stroll in the Park", diffgrp, "04");
	diffgrp = makeradio("Easy", diffgrp, "06");
	diffgrp = makeradio("Novice", diffgrp, "07");
	diffgrp = makeradio("Medium", diffgrp, "08");
	diffgrp = makeradio("Tricky", diffgrp, "09");
	diffgrp = makeradio("Hard", diffgrp, "10");
	diffgrp = makeradio("Needs fast CPU", diffgrp, "11");
	makeradio("Slow on any CPU", diffgrp, "12");
	gtk_widget_show(popup);
	return TRUE;
}	

/* create radio button for difficulty level selection */
GSList *makeradio(char *label, GSList *group, gpointer data)
{
	gint toggle_level(GtkWidget *widget, gpointer data);
	
	GtkWidget *btn;

	btn = gtk_radio_button_new_with_label(group, label);
	gtk_widget_show(btn);
	gtk_signal_connect(GTK_OBJECT(btn), "toggled",
			GTK_SIGNAL_FUNC(toggle_level), data);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(popup)->vbox), btn, TRUE, TRUE,
			0);
	if (twodigstr((char *) data) == pdepth)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), TRUE);
	return gtk_radio_button_group(GTK_RADIO_BUTTON(btn));
}

gint toggle_level(GtkWidget *widget, gpointer data)
{
	pdepth = twodigstr((char *) data);
	return TRUE;
}

gint diff_ok(GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy(popup);
	return TRUE;
}

gint about(GtkWidget *widget, gpointer data)
{
	gint about_ok(GtkWidget *widget, gpointer data);
	
	GtkWidget *bok, *label;
	
	popup = gtk_dialog_new();
	gtk_window_set_modal(GTK_WINDOW(popup), TRUE);
	gtk_container_set_border_width(GTK_CONTAINER(popup), 10);
	bok = makebutton("OK", GTK_SIGNAL_FUNC(about_ok));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(popup)->action_area), bok,
			TRUE, TRUE, 40);
	label = gtk_label_new(aboutt);
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(popup)->vbox), label, TRUE,
				TRUE, 10);
	gtk_widget_show(popup);
	return TRUE;
}

gint about_ok(GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy(popup);
	return TRUE;
}

gint howto(GtkWidget *widget, gpointer data)
{
	gint howto_ok(GtkWidget *widget, gpointer data);
	
	GtkWidget *bok, *label;
	
	popup = gtk_dialog_new();
	gtk_window_set_modal(GTK_WINDOW(popup), TRUE);
	gtk_container_set_border_width(GTK_CONTAINER(popup), 10);
	bok = makebutton("OK", GTK_SIGNAL_FUNC(howto_ok));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(popup)->action_area), bok,
			TRUE, TRUE, 40);
	label = gtk_label_new(playt);
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(popup)->vbox), label, TRUE,
				TRUE, 10);
	gtk_widget_show(popup);
	return TRUE;
}

gint howto_ok(GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy(popup);
	return TRUE;
}
	
/* button with label wrapper */
GtkWidget *makebutton(char *label, GtkSignalFunc func)
{
	GtkWidget *btn;

	btn = gtk_button_new_with_label(label);
	gtk_widget_show(btn);
	gtk_signal_connect(GTK_OBJECT(btn), "clicked", GTK_SIGNAL_FUNC(func),
			NULL);
	return btn;
}

/* build the drop down menus */
GtkWidget *setupmenus(void)
{
	gint start_game(GtkWidget *widget, gpointer data);
	gint restart_game(GtkWidget *widget, gpointer data);
	gint difficulty(GtkWidget *widget, gpointer data);
	gint about(GtkWidget *widget, gpointer data);
	gint howto(GtkWidget *widget, gpointer data);
	GtkWidget *buildmenu(char *label, GtkWidget *menu, GtkSignalFunc func);
	
	GtkWidget *menubar, *gamemenu, *game_mi, *helpmenu, *help_mi;
	
	menubar = gtk_menu_bar_new();
	gamemenu = gtk_menu_new();
	game_mi = gtk_menu_item_new_with_label("Game");
	gtk_widget_show(game_mi);
	start_mi = buildmenu("Start", gamemenu, GTK_SIGNAL_FUNC(start_game));
	restart_mi = buildmenu("Restart", gamemenu, 
			GTK_SIGNAL_FUNC(restart_game));
	gtk_widget_hide(restart_mi);
	buildmenu("Select Difficulty Level", gamemenu, 
			GTK_SIGNAL_FUNC(difficulty));
	buildmenu("Quit", gamemenu, GTK_SIGNAL_FUNC(destroy));
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(game_mi), gamemenu);
	gtk_menu_bar_append(GTK_MENU_BAR(menubar), game_mi);
	helpmenu = gtk_menu_new();
	help_mi = gtk_menu_item_new_with_label("Help");
	gtk_widget_show(help_mi);
	buildmenu("About", helpmenu, GTK_SIGNAL_FUNC(about));
	buildmenu("How To Play", helpmenu, GTK_SIGNAL_FUNC(howto));
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(help_mi), helpmenu);
	gtk_menu_bar_append(GTK_MENU_BAR(menubar), help_mi);
	gtk_widget_show(menubar);
	return menubar;
}
	
/* create menu item */
GtkWidget *buildmenu(char *label, GtkWidget *menu, GtkSignalFunc menufunc)
{
	GtkWidget *menuitem;
	
	menuitem = gtk_menu_item_new_with_label(label);
	gtk_menu_append(GTK_MENU(menu), menuitem);
	gtk_signal_connect(GTK_OBJECT(menuitem), "activate", 
			GTK_SIGNAL_FUNC(menufunc), (gpointer) label);
	gtk_widget_show(menuitem);
	return menuitem;
}

/* set up pixmaps to be used by the game */
void setuppixmaps(void)
{
	GtkStyle *style;
	
	style = gtk_widget_get_style(window);
	emptysq_pm = gdk_pixmap_create_from_xpm_d(window->window, &emptysq_mask,
		&style->bg[GTK_STATE_NORMAL], (gchar**) emptysq_xpm);
	redsq_pm = gdk_pixmap_create_from_xpm_d(window->window, &redsq_mask,
		&style->bg[GTK_STATE_NORMAL], (gchar**) redsq_xpm);
	offredsq_pm = gdk_pixmap_create_from_xpm_d(window->window,
			&offredsq_mask, &style->bg[GTK_STATE_NORMAL],
			(gchar**) offredsq_xpm);
	yelsq_pm =gdk_pixmap_create_from_xpm_d(window->window, &yelsq_mask
		, &style->bg[GTK_STATE_NORMAL], (gchar**) yelsq_xpm);
	offyelsq_pm = gdk_pixmap_create_from_xpm_d(window->window,
			&offyelsq_mask, &style->bg[GTK_STATE_NORMAL],
			(gchar**) offyelsq_xpm);
	lvedge_pm = gdk_pixmap_create_from_xpm_d(window->window, &lvedge_mask,
		&style->bg[GTK_STATE_NORMAL], (gchar**) lvedge_xpm);
	rvedge_pm = gdk_pixmap_create_from_xpm_d(window->window, &rvedge_mask,
		&style->bg[GTK_STATE_NORMAL], (gchar**) rvedge_xpm);
	tlcorner_pm =gdk_pixmap_create_from_xpm_d(window->window, &tlcorner_mask
		, &style->bg[GTK_STATE_NORMAL], (gchar**) tlcorner_xpm);
	trcorner_pm =gdk_pixmap_create_from_xpm_d(window->window, &trcorner_mask
		, &style->bg[GTK_STATE_NORMAL], (gchar**) trcorner_xpm);
	bedge_pm = gdk_pixmap_create_from_xpm_d(window->window, &bedge_mask,
		&style->bg[GTK_STATE_NORMAL], (gchar**) bedge_xpm);
	blcorner_pm =gdk_pixmap_create_from_xpm_d(window->window, &blcorner_mask
		, &style->bg[GTK_STATE_NORMAL], (gchar **) blcorner_xpm);
	brcorner_pm =gdk_pixmap_create_from_xpm_d(window->window, &brcorner_mask
		, &style->bg[GTK_STATE_NORMAL], (gchar**) brcorner_xpm);
}

/* set up move selection buttons */
void setupbuttons(void)
{
	int i;
	GtkWidget *arrow;
	
	for (i = 0; i < COLS; i++) {
		arrow = gtk_arrow_new(GTK_ARROW_DOWN, GTK_SHADOW_OUT);
		button[i] = gtk_button_new();
		gtk_container_add(GTK_CONTAINER(button[i]), arrow);
		gtk_widget_show(arrow);
		enter_table(i + 1, 0, button[i]);
		bid[i] = i;
	}
}

/* enter widget into single table cell */
void enter_table(int y, int x, GtkWidget *content)
{
	tablewid[y][x] = content;
	gtk_table_attach_defaults(GTK_TABLE(table), tablewid[y][x], y, y + 1,
				x, x + 1);
	gtk_widget_show(tablewid[y][x]);
}

/* set up the playing board */
void buildboard(void)
{
	int i, j;
	
	for (i = 1; i < COLS + 1; i++) {
		enter_table(i, ROWS + 2, gtk_pixmap_new(bedge_pm, bedge_mask));
		for (j = 2; j < ROWS + 2; j++)
			enter_table(i, j, gtk_pixmap_new(emptysq_pm, 
						emptysq_mask));
	}
	for (j = 2; j < ROWS + 2; j++) {
		enter_table(0, j, gtk_pixmap_new(lvedge_pm, lvedge_mask));
		enter_table(COLS + 1, j, gtk_pixmap_new(rvedge_pm, rvedge_mask));
	}
	enter_table(0, 1, gtk_pixmap_new(tlcorner_pm, tlcorner_mask));
	enter_table(COLS + 1, 1, gtk_pixmap_new(trcorner_pm, trcorner_mask));
	enter_table(0, ROWS + 2, gtk_pixmap_new(blcorner_pm, blcorner_mask));
	enter_table(COLS + 1, ROWS + 2, gtk_pixmap_new(brcorner_pm, 
				brcorner_mask));
}
