/* c4text.c - front end user interface for c4.c
 * (C) Paul A. Marshall 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "c4.h"
#include "c4mac.h"
#include "info.h"

void display_board(void);
int usermove(char player);
char getvalchar(char *valid);

int main(int argc, char *argv[])
{
	char sorf, level;
	char uplayer, cplayer;
	
	init_game();
	printf("\n\nWelcome to C4\n\n");
	printf("%s", aboutt);
	printf("\n\nEnter difficulty level (0 - 9) ");
	printf("or hit 'r' to find out how to play the game : ");
	level = getvalchar("r0123456789");
	if (level == 'r') {
		printf("\n%s", playt);
		printf("\n\nEnter difficulty level (0 - 9) : ");
		level = getvalchar("0123456789");
	}
	pdepth = level - '0' + 2;
	printf("\n\nWould you like to go first or second? (f/s) :");
	sorf = getvalchar("sf");
	if (sorf == 'f') {
		uplayer = PLAYER1;
		cplayer = PLAYER2;
	}
	else {
		uplayer = PLAYER2;
		cplayer = PLAYER1;
	}
	while (movenum < TOTALCELLS) {
		display_board();
		if (((sorf == 'f') && (!(movenum & 1))) ||
			((sorf == 's') && (movenum & 1))) {
			if (usermove(uplayer)) {
				display_board();
				printf("\nBah! You win!\n");
				exit(0);
			}
		}
		else {
			printf("\nI am thinking....\n");
			if (computer_move(cplayer)) {
				display_board();
				printf("\nHa! Ha! I win!\n");
				exit(0);
			}
		}
	}
	printf("\nA draw!\n");
	exit(0);
}

/* display the playing board */
void display_board(void)
{
	int i, j;
	char dispch;

	if (movenum > 0)
		printf("\n\nLast column played : %d", lastmove);
	for (j = ROWS - 1; j >= 0; j--) {
		printf("\n\n");
		for (i = 0; i < COLS; i++) {
			if (board[i][j] == 0)
				dispch = '.';
			if (board[i][j] == PLAYER1)
				dispch = 'X';
			if (board[i][j] == PLAYER2)
				dispch = 'O';
			printf("  %c  ", dispch);
		}
	}
	printf("\n\n\n  0    1    2    3    4    5    6\n");
}

int usermove(char player)
{
	int move, i, j;
	char valid[COLS + 1];

	j = 0;
	for (i = 0; i < COLS; i++)
		if (valid_move(i))
			valid[j++] = '0' + i;
	valid[j] = 0;
	printf("\nEnter column number to play (0-%d) :", COLS - 1);
	move = (int) (getvalchar(valid) - '0');
	if (user_move(player, move))
		return 1;
	else
		return 0;
}

/* get valid character from stdin */
char getvalchar(char *valid)
{
	/* 20 is arbitrary. If our demented user enters more than that, it will
	 * result in multiple occurences of the "invalid entry" message.
	 * What we're after is a string of length 2 = 1 char + return
	 */
	char inps[20];
	int validc, i;
	int flag = 0;

	validc = strlen(valid);
	do {
		if ((fgets(inps, 20, stdin) != 0) && (strlen(inps) == 2)) {
			inps[0] = tolower(inps[0]);
			for (i = 0; i < validc; i++)
				if (inps[0] == valid[i])
					flag = 1;
		}
		if (flag == 0)
			printf("\nInvalid entry, please try again : ");
	} while (flag == 0);
	return inps[0];
}
