/* cursed.h */
/* by Paul A. Marshall 2001 */

#include <curses.h>
#include <signal.h>

#define VERSION			"0.0.1"

/* signals to be provided with termination pre-handlers */
int	siglist[] = 	{SIGFPE, SIGILL, SIGSEGV, SIGBUS, SIGABRT, SIGSYS,
			SIGTERM, SIGINT, SIGQUIT, SIGHUP, 0};

/* invader settings */

#define		FRAME1		0x04 /* invader status flags */
#define		EXPLODING	0x02
#define		DEAD		0x01
#define		RIGHT		0x01 /* invader direction flags */
#define		DOWN		0x02
#define		NEXTDOWN	0x04 /* means down will be the next move */

#define		INVADERROWS	4
#define		INVADERCOLS	11
#define		INVADERTOTAL	(INVADERROWS * INVADERCOLS)

/* invader pictures. correct picture can be found thus:
 * invaderpic + (type * 8) + (frame * 4)
 * zeroes are there just to make the above possible via bit shifts
 * ...and to waste memory ;)
 */
chtype	invaderpic[] = 	{'/', '"' | A_REVERSE, '\\', 0,	/* /"\ */
			 '\\', '"' | A_REVERSE, '/', 0,	/* \"/ */
			 '<', 'M' | A_REVERSE, '>', 0,
			 '>', 'M' | A_REVERSE, '<', 0,
			 ')', 'W' | A_REVERSE, '(', 0,
			 '(', 'W' | A_REVERSE, ')', 0,
			 ']', 'A' | A_REVERSE, '[', 0,
			 '[', 'A' | A_REVERSE, ']', 0};
#define		EXPLOSION	'*'

/* bomb settings */
#define		MAXBOMBS	4	/* anything higher too hard for me */
#define		BOMB		';'

/* ship settings */
#define		SHIP		"<[^]>"
#define		MISSILE		'.'
#define		SHIPY		23	/* row occupied by ship */
#define		LIVES		3

/* barricade settings */
#define		BARRICADE_Y	18	/* top row of barricade */	
#define		BARRICADE_H	4	/* barricade height */
#define		BARRICADE_W	79	/* barricade width */
/* 1 = block, 0 = gap */
char	b_row[BARRICADE_W] = {0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,
				0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,
				0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,
				0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,
				0,0,0,0,0,0,0,0};
char	b_lastrow[BARRICADE_W] = {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,
				0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,
				0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,
				0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1};
				
/* Mother ship settings */
#define		MOTHER_INTERVAL	100
#define		MOTHER_SCORE	500
#define		MOTHER_Y	1
#define		MOTHER_RIGHT	0x02
#define		MOTHER_ON	0x01
#define		MOTHER_EXPLODING	0x04
chtype mother_r[6] = {'>', ':', 'O' | A_REVERSE, 'O' | A_REVERSE,
			'O' | A_REVERSE, '>'};
chtype mother_l[6] = {'<', 'O' | A_REVERSE, 'O' | A_REVERSE, 'O' | A_REVERSE,
			':', '<'};

/* relative timings for everything */
#define		TICK_INTERVAL	50000	/* in microsec - basic tempo */
#define		INVADER_TICKS	6
#define		SHIP_TICKS	1
#define		BOMB_TICKS	2
#define		MISSILE_TICKS	1
#define		MOTHER_TICKS	3

/* some data structures */

typedef struct {
	char	type;
	char	status;
	int	x;
	int	y;
} invt;

typedef struct {
	int	x;
	int	y;
} bombt;
